/*
 * @Description:5 * @Date: 2020-06-03 09:32:04
 * @Author: 陳挺 tony@e-besthealth.com
 * @LastEditors: 陳挺 tony@e-besthealth.com
 * @LastEditTime: 2020-06-19 11:16:29
 * @copyright: BEST HEALTH ELECTRONIC INC (c) 2020
 */
#include "common.h"
#include "..\BH67F5362_Drv\Drv_24BitADC.h"
unsigned char RegData, RegAddress;
unsigned char CommandData, CommandAddress;
unsigned char Status;
void main()
{
	// 判斷是否為上電復位或者非正常情況下的復位
	// 如果是上電復位，執行上電復位初始化，反之執行WDT溢出初始化
	if (_to == 0 || _pdf ==0)
	{
		// System
		Drv_SysClockInit();
		Drv_RamInit();
		SET_WDTTIME_125MS();
		SET_LVR_1V9();
		Drv_UART0_Init();
//		Drv_UART1_Init();
		Drv_24BitADC_Init();
		Drv_24BitADC_Start();
	}
	else
	{
		// WDT溢出復位初始化
		GCC_CLRWDT();
	}
	//主循環
	while(1)
	{
		GCC_CLRWDT();
		Drv_24BitADC_ReadADCData();
		if (ADCSourceData.flag.b.IsReady)
		{
			ADCSourceData.flag.b.IsReady = 0;
			DrvUart0Format.TxBuf[0] = 0xA2;
			DrvUart0Format.TxBuf[1] = 0x00;
			DrvUart0Format.TxBuf[2] = ADCSourceData.data.byte.ByteHigh;
			DrvUart0Format.TxBuf[3] = ADCSourceData.data.byte.ByteMid;
			DrvUart0Format.TxBuf[4] = ADCSourceData.data.byte.ByteLow;
			DrvUart0Format.TxBuf[5] = ADCSourceData.data.byte.ByteRes;
			DrvUart0Format.TxBuf[6] = 0x00;
			unsigned char i;
			for (i = 0; i < 6; i++)
			{
				DrvUart0Format.TxBuf[6] += DrvUart0Format.TxBuf[i];
			}
			Drv_Uart0StartTx(7);
		}

		// UART RX
		if (DrvUart0Format.flag.b.IsRxSuccess)
		{
			DrvUart0Format.flag.b.IsRxSuccess = 0;
			unsigned char i, CheckSum = 0x00;
			for (i = 0; i < 6; i++)
			{
				CheckSum += DrvUart0Format.RxBuf[i];
			}
			if (CheckSum == DrvUart0Format.RxBuf[6])
			{
				switch (DrvUart0Format.RxBuf[0])
				{
				case 0xA0:	// Read Write Register Command
					RegAddress = DrvUart0Format.RxBuf[3];
					RegData = DrvUart0Format.RxBuf[5];
					if (RegAddress <= HIRCC){
						Status = 0x01;
					}
					else{
						Status = 0x02;	// 地址錯誤
					}
					if (DrvUart0Format.RxBuf[1] == 0x01){
						RegData = Drv_24BitADC_ReadReg(RegAddress);
					}
					else if (DrvUart0Format.RxBuf[1] == 0x02){
						Drv_24BitADC_WriteReg(RegAddress, RegData);
					}
					// ACK
					DrvUart0Format.TxBuf[0] = 0xA0;
					DrvUart0Format.TxBuf[1] = Status;
					DrvUart0Format.TxBuf[2] = 0x00;
					DrvUart0Format.TxBuf[3] = RegAddress;
					DrvUart0Format.TxBuf[4] = 0x00;
					DrvUart0Format.TxBuf[5] = RegData;
					DrvUart0Format.TxBuf[6] = 0xA0 + Status + RegAddress + RegData;
					Drv_Uart0StartTx(7);
					break;
				case 0xA1:	// MCU狀態控制
					CommandAddress = DrvUart0Format.RxBuf[3];
					CommandData = DrvUart0Format.RxBuf[5];
					
					Status = 0x02; // 成功01 OR 失敗02
					if (CommandAddress == 0x10 && DrvUart0Format.RxBuf[1] == 0x02)
					{
						if (CommandData == 0x02)
						{
							Drv_24BitADC_Stop();
							Status = 0x01;
						}
						else if (CommandData == 0x01)
						{
							Drv_24BitADC_Start();
							Status = 0x01;
						}
					}
					// ACK
					DrvUart0Format.TxBuf[0] = 0xA1;
					DrvUart0Format.TxBuf[1] = Status;
					DrvUart0Format.TxBuf[2] = 0x00;
					DrvUart0Format.TxBuf[3] = CommandAddress;
					DrvUart0Format.TxBuf[4] = 0x00;
					DrvUart0Format.TxBuf[5] = CommandData;
					DrvUart0Format.TxBuf[6] = 0xA1 + CommandAddress + CommandData;
					Drv_Uart0StartTx(7);
					break;
				default:
					break;
				}
			}
		}
	}
}
